// DAZ Store Hider — popup.js v3.2.0 (single injection fix)
const N = 10;
const $ = id => document.getElementById(id);
const normArr = arr => Array.from({length:N},(_,i)=> (arr && arr[i]) || {text:"",enabled:false});

const MASTER_KEY = "daz_hider_master_enabled";
const HIDE_KEY   = "daz_hider_rules";
const HL_KEY    = "daz_hider_highlight_rules";
const SHOW_KEY   = "daz_hider_show_rules";
const PRICE_KEY  = "daz_hider_price_rules";
const HIDE_COL   = "daz_hider_col_hide_enabled";
const HL_COL    = "daz_hider_col_hl_enabled";
const SHOW_COL   = "daz_hider_col_show_enabled";
const PRICE_COL  = "daz_hider_col_price_enabled";

function setSection(prefix, rows, enabled){
  rows = normArr(rows);
  for(let i=0;i<N;i++){
    $(`${prefix}-text-${i}`).value    = rows[i].text || "";
    $(`${prefix}-en-${i}`).checked    = !!rows[i].enabled;
    $(`${prefix}-text-${i}`).disabled = !enabled;
    $(`${prefix}-en-${i}`).disabled   = !enabled;
  }
  (prefix==="hide"?$("panelHide"):prefix==="hl"?$("panelHL"):$("panelShow"))
    .classList.toggle("off", !enabled);
}
function getSection(prefix){
  const out = [];
  for(let i=0;i<N;i++){
    out[i] = {
    text: ($(`${prefix}-text-${i}`).value || "").trim(),
    enabled: $(`${prefix}-en-${i}`).checked
    };
  }
  return normArr(out);
}
function setPriceSection(rows, enabled){
  $(`price-min-text`).value    = (rows && rows.min) || "";
  $(`price-max-text`).value    = (rows && rows.max) || "";
  $(`price-min-en`).checked    = !!(rows && rows.minEnabled);
  $(`price-max-en`).checked    = !!(rows && rows.maxEnabled);
  $(`price-min-text`).disabled = !enabled;
  $(`price-max-text`).disabled = !enabled;
  $(`price-min-en`).disabled   = !enabled;
  $(`price-max-en`).disabled   = !enabled;
  $("panelPrice").classList.toggle("off", !enabled);
}
function getPriceSection(){
  return {
    min: ($("price-min-text").value || "").trim(),
    max: ($("price-max-text").value || "").trim(),
    minEnabled: $("price-min-en").checked,
    maxEnabled: $("price-max-en").checked
  };
}
function wireColumnToggle(prefix, cbId){
  $(cbId).addEventListener("change", e=>{
    const on = e.target.checked;
    for(let i=0;i<N;i++){
    $(`${prefix}-text-${i}`).disabled = !on;
    $(`${prefix}-en-${i}`).disabled   = !on;
    }
    (prefix==="hide"?$("panelHide"):prefix==="hl"?$("panelHL"):$("panelShow"))
    .classList.toggle("off", !on);
  });
}
function wirePriceColumnToggle(cbId){
  $(cbId).addEventListener("change", e=>{
    const on = e.target.checked;
    $(`price-min-text`).disabled = !on;
    $(`price-max-text`).disabled = !on;
    $(`price-min-en`).disabled   = !on;
    $(`price-max-en`).disabled   = !on;
    $("panelPrice").classList.toggle("off", !on);
  });
}

function loadLatestGalleryImage() {
  const galleryLoading = $("gallery-loading");
  const galleryContent = $("gallery-content");
  const galleryImage = $("gallery-image");
  const galleryImageLink = $("gallery-image-link");
  const galleryTitleLink = $("gallery-title-link");

  if (!galleryLoading || !galleryContent || !galleryImage || !galleryImageLink || !galleryTitleLink) {
    console.log("[DAZ Hider Popup] Gallery elements not found, skipping gallery load");
    return;
  }

  chrome.runtime.sendMessage({ action: "FETCH_GALLERY" }, (response) => {
    if (response && response.success) {
      galleryImage.src = response.imageSrc;
      galleryImageLink.href = response.imageUrl;
      galleryTitleLink.href = response.imageUrl;
      galleryTitleLink.textContent = response.imageTitle;
      
      galleryLoading.style.display = "none";
      galleryContent.style.display = "block";
    } else {
      galleryLoading.textContent = "Failed to load image";
      console.error("[DAZ Hider Popup] Gallery fetch failed:", response?.error);
    }
  });
}

function broadcastToLocalStorage(state) {
  chrome.storage.sync.set(state, () => {
    console.log("[DAZ Hider Popup] ✅ Saved to chrome.storage.sync");
  });

  chrome.tabs.query({url:["https://store.daz3d.com/*","https://www.daz3d.com/*"]}, tabs=>{
    const stateStr = JSON.stringify(state);
    tabs.forEach(tab => {
      chrome.scripting.executeScript({
        target: { tabId: tab.id },
        func: (stateStr) => {
          try {
            const current = localStorage.getItem('daz_hider_state');
            if (current !== stateStr) {
              localStorage.setItem('daz_hider_state', stateStr);
              console.log("[DAZ Hider] State updated via localStorage");
            }
          } catch (e) {
            console.error("[DAZ Hider] Could not write to localStorage:", e);
          }
        },
        args: [stateStr]
      }).catch(err => {});
    });
  });
}

document.addEventListener("DOMContentLoaded", ()=>{
  chrome.storage.sync.get([
    MASTER_KEY, HIDE_KEY, HL_KEY, SHOW_KEY, PRICE_KEY,
    HIDE_COL, HL_COL, SHOW_COL, PRICE_COL
  ], (stored) => {
    console.log("[DAZ Hider Popup] Loaded from chrome.storage.sync:", stored);

    const master = $("master");
    master.checked = stored[MASTER_KEY] !== false;

    const colHide = stored[HIDE_COL] !== false;
    const colHL   = stored[HL_COL] !== false;
    const colShow = stored[SHOW_COL] !== false;
    const colPrice = stored[PRICE_COL] !== false;

    $("col-hide").checked = colHide;
    $("col-hl").checked   = colHL;
    $("col-show").checked = colShow;
    $("col-price").checked = colPrice;

    setSection("hide", stored[HIDE_KEY], colHide);
    setSection("hl",   stored[HL_KEY], colHL);
    setSection("show", stored[SHOW_KEY], colShow);
    setPriceSection(stored[PRICE_KEY], colPrice);

    wireColumnToggle("hide","col-hide");
    wireColumnToggle("hl","col-hl");
    wireColumnToggle("show","col-show");
    wirePriceColumnToggle("col-price");

    loadLatestGalleryImage();
  });

  $("save").addEventListener("click", ()=>{
    const payload = {
      [MASTER_KEY]: $("master").checked,
      [HIDE_KEY]: getSection("hide"),
      [HL_KEY]: getSection("hl"),
      [SHOW_KEY]: getSection("show"),
      [PRICE_KEY]: getPriceSection(),
      [HIDE_COL]: $("col-hide").checked,
      [HL_COL]: $("col-hl").checked,
      [SHOW_COL]: $("col-show").checked,
      [PRICE_COL]: $("col-price").checked
    };

    console.log("[DAZ Hider Popup] Saving:", payload);
    broadcastToLocalStorage(payload);

// Ask open DAZ shop tabs to refresh filtering immediately
chrome.tabs.query({ url: ["https://store.daz3d.com/*", "https://www.daz3d.com/*"] }, (tabs) => {
  for (const tab of tabs) {
    try {
      chrome.tabs.sendMessage(tab.id, { type: "FORCE_REFRESH" }, () => {
        void chrome.runtime.lastError; // ignore if tab has no content script yet
      });
    } catch (e) {
      // ignore
    }
  }
});


    const s = $("status"); 
    s.textContent = "Preferences Saved.";
    s.className = "hint ok"; 
    setTimeout(()=>{ s.textContent=""; s.className="hint"; }, 900);
  });
});